﻿using System;
using System.Text;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VIMT.VideoVisit.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Create
{
    public class ValidateBusinessRulesStep : FilterBase<VideoVisitCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitCreateStateObject state)
        {
            var errors = ValidateAllBusinessRules(state.Appointment);
            if (string.IsNullOrEmpty(errors)) return;

            errors += "\n\n" + state.SerializedAppointment;
            throw new Exception(errors);
        }

        private static string ValidateAllBusinessRules(VIMTTmpCreateAppointmentRequestData ecRequest)
        {
            var validationErrors = new StringBuilder();
            //TO DO check that all business rules are met and either return false or else
            var validator = new BusinessRuleValidator();
            validationErrors
                .Append(validator.CheckPatientCount(ecRequest.Patients))
                .Append(validator.CheckAppointmentKind(ecRequest))
                .Append(validator.CheckLocationTypes(ecRequest))
                .Append(validator.CheckPatientAssigningAuthorityAndName(ecRequest.Patients))
                .Append(validator.CheckPatientEmail(ecRequest.Patients, ecRequest.AppointmentKind))
                .Append(validator.CheckProviderEmail(ecRequest.Providers))
                .Append(validator.CheckVmrs(ecRequest));

            return validationErrors.ToString().Trim('|');
        }
    }
}